/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json.view.devicelist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hmdm.persistence.domain.ConfigurationFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@JsonIgnoreProperties(value={"file"}, ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(description="A specification of a single configuration file available for usage on mobile device")
public class ConfigurationFileView
implements Serializable {
    private final ConfigurationFile file;

    public ConfigurationFileView(ConfigurationFile file) {
        this.file = file;
    }

    @ApiModelProperty(value="A flag indicating if file is to be removed from the device or not")
    public boolean isRemove() {
        return this.file.isRemove();
    }

    @ApiModelProperty(value="A timestamp of file uploading to server (in milliseconds since epoch time)")
    public Long getLastUpdate() {
        return this.file.getLastUpdate();
    }

    @ApiModelProperty(value="A path to a file on device")
    @JsonProperty(value="path")
    public String getDevicePath() {
        return this.file.getDevicePath();
    }
}

