/*
 * Decompiled with CFR 0.152.
 */
package com.hmdm.rest.json.view;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.hmdm.persistence.domain.Customer;
import com.hmdm.persistence.domain.UploadedFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.Serializable;
import java.util.List;

@ApiModel(description="A single file maintained by the MDM server")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FileView
implements Serializable {
    private static final long serialVersionUID = 7570897379289300175L;
    @ApiModelProperty(value="Id of the basic UploadedFile object")
    private Integer id;
    @ApiModelProperty(value="A path to file including the file name")
    private String filePath;
    @ApiModelProperty(value="An optional file description")
    private String description;
    @ApiModelProperty(value="An URL of file")
    private String url;
    @ApiModelProperty(value="File size in bytes")
    private long size;
    @ApiModelProperty(value="Last update time in ms")
    private long uploadTime;
    @ApiModelProperty(value="File path on the device")
    private String devicePath;
    @ApiModelProperty(value="A flag showing whether the file has an external URL")
    private boolean external;
    @ApiModelProperty(value="A flag showing whether the file has variable content")
    private boolean replaceVariables;
    @Deprecated
    private List<String> usedByApps;
    private List<String> usedByIcons;
    private List<String> usedByConfigurations;

    public FileView() {
    }

    public FileView(String path, String name, String url, long size) {
        this.filePath = String.valueOf(path) + (path.length() > 0 ? "/" : "") + name;
        this.url = url;
        this.size = size;
    }

    public FileView(UploadedFile f, String baseUrl, String filesDirectory, Customer customer) {
        this.setId(f.getId());
        this.setDescription(f.getDescription());
        this.setUrl(f.getUrl(baseUrl, customer));
        if (!f.isExternal()) {
            this.setFilePath(f.getFilePath().replace(File.separator, "/"));
            File file = f.getFileByPath(filesDirectory, customer);
            if (!file.exists()) {
                this.setSize(-1L);
            } else {
                this.setSize(file.length());
            }
            this.setUploadTime(f.getUploadTime().longValue());
        }
        this.setDevicePath(f.getDevicePath());
        this.setExternal(f.isExternal());
        this.setReplaceVariables(f.isReplaceVariables());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getUploadTime() {
        return this.uploadTime;
    }

    public void setUploadTime(long uploadTime) {
        this.uploadTime = uploadTime;
    }

    public String getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(String devicePath) {
        this.devicePath = devicePath;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public boolean isReplaceVariables() {
        return this.replaceVariables;
    }

    public void setReplaceVariables(boolean replaceVariables) {
        this.replaceVariables = replaceVariables;
    }

    public List<String> getUsedByApps() {
        return this.usedByApps;
    }

    public void setUsedByApps(List<String> usedByApps) {
        this.usedByApps = usedByApps;
    }

    public List<String> getUsedByIcons() {
        return this.usedByIcons;
    }

    public void setUsedByIcons(List<String> usedByIcons) {
        this.usedByIcons = usedByIcons;
    }

    public List<String> getUsedByConfigurations() {
        return this.usedByConfigurations;
    }

    public void setUsedByConfigurations(List<String> usedByConfigurations) {
        this.usedByConfigurations = usedByConfigurations;
    }
}

